<?php
namespace App\Events;

use Illuminate\Queue\SerializesModels;

class MessageSentEvent
{
    use SerializesModels;

    public $orderId;
    public $senderId;
    public $receiverId;
    public $messageContent;

    public function __construct($orderId, $senderId, $receiverId, $messageContent)
    {
        $this->orderId = $orderId;
        $this->senderId = $senderId;
        $this->receiverId = $receiverId;
        $this->messageContent = $messageContent;
    }
    public function broadcastOn()
{
    return new PrivateChannel('order.' . $this->message->order_id);
}
}
