<?php
namespace App\Listeners;

use App\Events\MessageSentEvent;
use App\Jobs\SendMessageJob;

class SendMessageListener
{
    public function handle(MessageSentEvent $event)
    {
        // Dispatch job to send message automatically
        SendMessageJob::dispatch(
            $event->orderId,
            $event->senderId,
            $event->receiverId,
            $event->messageContent
        );
    }
}
