<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CreatorService extends Model
{
    protected $fillable = [
        'creator_profile_id', // Foreign key to identify the creator
        'service_title',
        'service_price',
    ];

    // A service belongs to one creator profile (Content Creator)
    public function creatorProfile()
    {
        return $this->belongsTo(CreatorProfile::class, 'creator_profile_id');
    }

}
