<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
 
class Order extends Model
{
    use HasFactory;
        protected $fillable = [
            'buyer_id',
            'gig_id',
            'buyer_name',
            'email',
            'project_details',
            'budget',
            'expected_delivery_date',
            'label',
            'start_date',
            'end_date',
            'milestone',
            'status',
            'progress_status',

        ];
        

    public function gig()
    {
        return $this->belongsTo(Gig::class);
    }

    public function buyer()
    {
        return $this->belongsTo(User::class, 'buyer_id');
    }


    public function contentCreator()
    {
        return $this->belongsTo(User::class, 'content_creator_id');
    }

}
