<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Story extends Model
{
    use HasFactory;

    protected $fillable = [
        'content_creator_id',
        'media_path',
        'caption',
        'expires_at',
    ];

    /**
     * A story belongs to a content creator
     */
    public function creator()
    {
        return $this->belongsTo(ContentCreator::class, 'content_creator_id');
    }

    /**
     * Scope to get only non-expired stories (if needed)
     */
    public function scopeActive($query)
    {
        return $query->where('expires_at', '>', now());
    }
}
