<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\User;

class ProfileDeletedNotification extends Notification
{
    use Queueable;

    protected $creator;

    public function __construct(User $creator)
    {
        $this->creator = $creator;
    }

    public function via($notifiable)
    {
        return ['mail']; // you can also add 'database' if needed
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Content Creator Profile Deleted')
            ->line('A content creator has deleted their profile.')
            ->line('Name: ' . $this->creator->name)
            ->line('ID: ' . $this->creator->id)
            ->line('Email: ' . $this->creator->email);
    }
    public function toDatabase($notifiable)
{
    return [
        'creator_name' => $this->creator->name,
        'creator_id'   => $this->creator->id,
        'message'      => 'Content Creator has soft deleted their profile.',
    ];
}

}
