<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreatorServicesTable extends Migration
{
    public function up()
    {
        Schema::create('creator_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('creator_profile_id')->constrained()->onDelete('cascade');
            $table->string('service_title');
            $table->decimal('service_price', 10, 2);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('creator_services');
    }
}
