<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\CreatorProfile;
use App\Models\Skill;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class CreatorProfileSeeder extends Seeder
{
    public function run(): void
    {
        // Create 'Content Creator' role if not exists
        $role = Role::firstOrCreate(['name' => 'Content Creator']);

        // Create a test user
        $user = User::firstOrCreate(
            ['email' => 'creator@example.com'],
            [
                'name' => 'Test Creator',
                'password' => Hash::make('password'),
                'email_verified_at' => now()
            ]
        );

        // Assign role
        $user->assignRole($role);

        // Create profile
        $profile = CreatorProfile::firstOrCreate([
            'user_id' => $user->id
        ], [
            'expertise' => 'Video Editing',
            'about_me' => 'I create cinematic travel vlogs.'
        ]);

        // Create some skills
        $skills = ['Adobe Premiere Pro', 'After Effects', 'Cinematography'];
        foreach ($skills as $skillName) {
            Skill::firstOrCreate([
                'creator_profile_id' => $profile->id,
                'name' => $skillName
            ]);
        }

        $this->command->info('Creator profile and skills seeded successfully.');
    }
}
