<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\CreatorService;
use App\Models\CreatorProfile;
use Faker\Factory as Faker;

class CreatorServiceSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Ensure there are CreatorProfiles to associate with services
        $creatorProfiles = CreatorProfile::all();

        if ($creatorProfiles->count() > 0) {

            // Create a variety of meaningful services for each content creator
            foreach ($creatorProfiles as $creatorProfile) {
                $services = [
                    'Photography',
                    'Web Development',
                    'Graphic Design',
                    'SEO Optimization',
                    'Social Media Management',
                    'Content Writing',
                    'App Development',
                    'Brand Consulting',
                    'Video Editing',
                    'UX/UI Design',
                ];

                foreach ($services as $serviceTitle) {
                    CreatorService::create([
                        'creator_profile_id' => $creatorProfile->id,
                        'service_title' => $serviceTitle,
                        'service_price' => $faker->randomFloat(2, 50, 500),  // Random price between 50 and 500
                    ]);
                }
            }

            // Add the same service title multiple times for testing recommendations
            $repeatedServices = [
                'Photography', 'Photography', 'Photography', 'Photography', 'Photography', // Repeat "Photography" 5 times
                'Web Development', 'Web Development', 'Web Development', 'Web Development', 'Web Development', // Repeat "Web Development" 5 times
                'SEO Optimization', 'SEO Optimization', 'SEO Optimization', 'SEO Optimization', 'SEO Optimization', // Repeat "SEO Optimization" 5 times
                'Content Writing', 'Content Writing', 'Content Writing', 'Content Writing', 'Content Writing', // Repeat "Content Writing" 5 times
                'Graphic Design', 'Graphic Design', 'Graphic Design', 'Graphic Design', 'Graphic Design', // Repeat "Graphic Design" 5 times
            ];

            foreach ($repeatedServices as $serviceTitle) {
                for ($i = 0; $i < 5; $i++) {  // Repeat the same service title 5 times
                    CreatorService::create([
                        'creator_profile_id' => $creatorProfiles->random()->id,  // Assign to a random creator profile
                        'service_title' => $serviceTitle,
                        'service_price' => $faker->randomFloat(2, 50, 500),  // Random price between 50 and 500
                    ]);
                }
            }
        }
    }
}
