<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Notification;
use App\Models\User;

class NotificationSeeder extends Seeder
{
    public function run()
    {
        // Create a dummy notification
        $user1 = User::find(1); // Make sure this user exists
        $user2 = User::find(2); // Make sure this user exists

        // Check if users exist
        if (!$user1 || !$user2) {
            echo "One or both users not found!";
            return;
        }

        // Create a notification
        Notification::create([
            'sender_id' => $user1->id,
            'receiver_id' => $user2->id,
            'message' => 'You received a new order from ' . $user1->name . '.',
            'is_read' => false,
        ]);

        // You can create more dummy notifications as needed
        Notification::create([
            'sender_id' => $user2->id,
            'receiver_id' => $user1->id,
            'message' => 'You have a new message from ' . $user2->name . '.',
            'is_read' => false,
        ]);
    }
}
