<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use App\Models\Story;

class StorySeeder extends Seeder
{
    public function run(): void
    {
            // Path to the source image
            $sourcePath = storage_path('app/public/stories/story.png');

            if (!file_exists($sourcePath)) {
                dd('story.png not found. Please place it in storage/app/public/stories/');
            }

            for ($i = 1; $i <= 5; $i++) {
                $newFileName = 'story_' . Str::random(10) . '.jpg';
                $destination = storage_path('app/public/stories/' . $newFileName);

                // Copy dummy file
                copy($sourcePath, $destination);

                Story::create([
                    'content_creator_id' => 1,
                    'media_path' => 'stories/' . $newFileName, // <== this is correct now
                    'caption' => "Local story demo {$i}",
                    'expires_at' => now()->addHours(24),
                ]);
            }
        }
}
