<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use App\Models\Transaction;

class StripePaymentController extends Controller
{


    public function createPaymentIntent(Request $request)
    {


        Stripe::setApiKey(config('services.stripe.secret'));

        $request->validate([
            'plan' => 'required|in:free,standard,premium',
            'currency' => 'required|string|size:3',
        ]);

        // Define your plans here or move to config
        $plans = [
            'free' => 0,
            'standard' => 1000, // $10 in cents
            'premium' => 2000,  // $20 in cents
        ];

        $selectedPlan = $request->plan;
        $amount = $plans[$selectedPlan];

        // If the plan is free, no need to create a PaymentIntent
        if ($amount == 0) {
            // You can still return a message or create a record
            return response()->json([
                'status' => 'success',
                'message' => 'Free plan activated. No payment needed.',
            ]);
        }

        // Create a Stripe PaymentIntent
        $intent = PaymentIntent::create([
            'amount' => $amount,
            'currency' => $request->currency,
            'payment_method_types' => ['card'],
        ]);

        // Log the transaction for pending status
        $userId = auth()->id();
        if (!$userId) {
            return response()->json(['error' => 'User not authenticated'], 401);
        }

        $transaction = Transaction::createPending(
            $userId,
            $selectedPlan,
            $intent->id,
            $amount,
            $request->currency
        );

        // Return the client secret so the frontend can process the payment
        return response()->json([
            'client_secret' => $intent->client_secret,
            'message' => 'Payment Intent created for ' . ucfirst($selectedPlan) . ' plan.',
        ]);
    }
}

