<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderSubmission extends Model
{
    use HasFactory;

    // Define the fillable attributes
    protected $fillable = [
        'order_id',
        'file_path',
        'message',
    ];

    // Define the relationship with the Order model
    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
