<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Carbon\Carbon;

class TransactionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks temporarily
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        $faker = Faker::create();

        // Assuming you want to seed 10 transactions
        foreach (range(1, 10) as $index) {
            DB::table('transactions')->insert([
                'user_id' => $faker->numberBetween(1, 10), // Random user_id (Assuming users with ID 1 to 10 exist)
                'plan' => $faker->randomElement(['free', 'standard', 'premium']),
                'payment_intent_id' => $faker->uuid,
                'amount' => $faker->numberBetween(1000, 5000),
                'currency' => 'USD',
                'status' => $faker->randomElement(['pending', 'succeeded', 'failed']),
                'created_at' => Carbon::now()->subDays(rand(1, 30)),
                'updated_at' => Carbon::now(),
            ]);
        }

        // Re-enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
