<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\ContentCreator;

class UserContentCreatorSeeder extends Seeder
{
    public function run(): void
    {
        // Create a new user
        $user = User::create([
            'name' => 'John Doe',
            'email' => 'john.doe@example.com',
            'password' => Hash::make('password123'),
        ]);

        // Create content creator data for this user
        $contentCreator = ContentCreator::create([
            'user_id' => $user->id,  // Linking user to content creator
            'instagram_handle' => 'john_doe_insta',
            'instagram_followers' => 1500,
            'youtube_channel' => 'john_doe_channel',
            'youtube_subscribers' => 20000,
        ]);

        echo "User and Content Creator created successfully!\n";
    }
}
