<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use App\Models\Transaction;
use Illuminate\Http\Request;

class StripeWebhookController extends Controller
{
    //
    public function handleWebhook(Request $request)
    {
        $payload = @file_get_contents('php://input');
        $sig_header = $request->header('Stripe-Signature');
        $endpoint_secret = config('services.stripe.webhook_secret');  // Set this in your .env

        try {
            $event = \Stripe\Webhook::constructEvent(
                $payload, $sig_header, $endpoint_secret
            );
        } catch (\Exception $e) {
            return response('Webhook signature verification failed', 400);
        }

        // Proceed if event type is payment_intent.succeeded
        if ($event->type === 'payment_intent.succeeded') {
            $intent = $event->data->object;  // Contains a Stripe PaymentIntent object

            $transaction = Transaction::where('payment_intent_id', $intent->id)->first();

            if ($transaction) {
                $transaction->status = 'succeeded';
                $transaction->save();
            }
        }

        return response('Webhook received', 200);
    }

}
