<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Mail;
use App\Events\MessageSent;
use App\Http\Controllers\OrderController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';



Route::get('/test-mail', function () {
    Mail::raw('This is a test email from Caleb app.', function ($message) {
        $message->to('calebabbas57@gmail.com')
                ->subject('Test Email');
    });

    return 'Email sent!';
});


Route::get('/send-message', function () {
    broadcast(new MessageSent('Hello from server!'));

    return 'Message Sent!';
});


Route::get('/order/{orderId}', [OrderController::class, 'showOrder'])->name('order.show');
