<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CreatorProfile;
use App\Models\Skill;
use App\Models\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\ProfileDeletedNotification;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class CreatorProfileController extends Controller
{
    use SoftDeletes;

    // public function show(Request $request)
    // {
    //     $user = $request->user();

    //     if (!$user->hasRole('Content Creator')) {
    //         return response()->json(['message' => 'Access Denied'], 403);
    //     }

    //     $profile = CreatorProfile::with('skills')->where('user_id', $user->id)->first();

    //     return response()->json([
    //         'name' => $user->name,
    //         'expertise' => $profile?->expertise,
    //         'about_me' => $profile?->about_me,
    //         'skills' => $profile?->skills->pluck('name'),
    //     ]);
    // }



  public function show(Request $request)
{
    $user = $request->user();

    if (!$user->hasRole('Content Creator')) {
        return response()->json(['message' => 'Access Denied'], 403);
    }

    // Eager-load only needed fields from skills
    $profile = CreatorProfile::with(['skills:id,creator_profile_id,name'])
        ->where('user_id', $user->id)
        ->first();

    // Build skills array (PHP 7-safe)
    $skills = [];
    if ($profile && $profile->skills) {
        $skills = $profile->skills->map(function ($skill) {
            return [
                'id'   => $skill->id,
                'name' => $skill->name,
            ];
        })->values()->all(); // ->all() returns a plain array
    }

    return response()->json([
        'name'           => $user->name,   // from users table
        'email'          => $user->email,  // from users table
        'expertise'      => $profile ? $profile->expertise : null,
        'about_me'       => $profile ? $profile->about_me : null,
        'skills'         => $skills,
    ]);
}




    // public function storeOrUpdate(Request $request)
    // {
    //     $request->validate([
    //         'expertise' => 'nullable|string',
    //         'about_me' => 'nullable|string',
    //     ]);

    //     $user = $request->user();

    //     $profile = CreatorProfile::updateOrCreate(
    //         ['user_id' => $user->id],
    //         ['expertise' => $request->expertise, 'about_me' => $request->about_me]
    //     );

    //     return response()->json(['message' => 'Profile saved successfully']);
    // }

    // 🛠️ CRUD for Skills:


//     public function storeOrUpdate(Request $request, $id)
// {
//     $request->validate([
//         'expertise' => 'nullable|string',
//         'about_me' => 'nullable|string',
//     ]);

//     $user = $request->user();
//     $profile = CreatorProfile::find($id);

//     if (!$profile || $profile->user_id !== $user->id) {
//         return response()->json(['message' => 'Unauthorized'], 403);
//     }

//     $profile->update([
//         'expertise' => $request->expertise,
//         'about_me' => $request->about_me
//     ]);

//     return response()->json(['message' => 'Profile updated successfully']);
// }


        public function addSkill(Request $request)
    {
        $request->validate(['name' => 'required|string']);

        $user = $request->user();
        $profile = CreatorProfile::firstOrCreate(['user_id' => $user->id]);

        $skill = $profile->skills()->create(['name' => $request->name]);

        return response()->json(['message' => 'Skill added', 'skill' => $skill]);
    }

    // public function updateSkill(Request $request, $id)
    // {
    //     $request->validate(['name' => 'required|string']);

    //     $skill = Skill::findOrFail($id);
    //     $skill->update(['name' => $request->name]);

    //     return response()->json(['message' => 'Skill updated', 'skill' => $skill]);
    // }



    public function store(Request $request)
    {
        $request->validate([
            'expertise' => 'required|string',
            'about_me'  => 'required|string',
        ]);

        $user = Auth::user();

        $profile = CreatorProfile::create([
            'user_id'   => $user->id,
            'expertise' => $request->expertise,
            'about_me'  => $request->about_me,
        ]);

        return response()->json([
            'message' => 'Creator profile created successfully.',
            'profile' => $profile
        ], 201);
    }

    // Update an Existing Creator Profile
    public function update(Request $request, $id)
    {
        $request->validate([
            'expertise' => 'nullable|string',
            'about_me'  => 'nullable|string',
        ]);

        $user = Auth::user();
        $profile = CreatorProfile::where('id', $id)->where('user_id', $user->id)->first();

        if (!$profile) {
            return response()->json(['message' => 'Profile not found or unauthorized.'], 404);
        }

        $profile->update($request->only(['expertise', 'about_me']));

        return response()->json([
            'message' => 'Creator profile updated successfully.',
            'profile' => $profile
        ]);
    }



    public function updateSkill(Request $request, $id)
{
    $request->validate(['name' => 'required|string']);

    $user = $request->user();
    $profile = CreatorProfile::where('user_id', $user->id)->first();

    if (!$profile) {
        return response()->json(['message' => 'Profile not found'], 404);
    }

    $skill = Skill::where('id', $id)
                  ->where('creator_profile_id', $profile->id)
                  ->first();

    if (!$skill) {
        return response()->json(['message' => 'Skill not found'], 404);
    }

    $skill->update(['name' => $request->name]);

    return response()->json(['message' => 'Skill updated', 'skill' => $skill]);
}


    // public function deleteSkill($id)
    // {
    //     $skill = Skill::findOrFail($id);
    //     $skill->delete();

    //     return response()->json(['message' => 'Skill deleted']);
    // }

    public function deleteSkill(Request $request, $id)
{
    $user = $request->user();

    // Get the creator profile for this user
    $profile = CreatorProfile::where('user_id', $user->id)->first();

    if (!$profile) {
        return response()->json(['message' => 'Profile not found'], 404);
    }

    // Only find the skill if it belongs to this profile
    $skill = Skill::where('id', $id)
                  ->where('creator_profile_id', $profile->id)
                  ->first();

    if (!$skill) {
        return response()->json(['message' => 'Skill not found or does not belong to user'], 404);
    }

    $skill->delete();

    return response()->json(['message' => 'Skill deleted']);
}


    // public function destroy(Request $request)
    // {
    //     $user = $request->user();
    //     $profile = CreatorProfile::where('user_id', $user->id)->first();

    //     if (!$profile) {
    //         return response()->json(['message' => 'Profile not found'], 404);
    //     }

    //     // If user is Admin or the profile belongs to the user
    //     if (!$user->hasRole('Admin') && $profile->user_id !== $user->id) {
    //         return response()->json(['message' => 'Unauthorized'], 403);
    //     }

    //     // Soft delete the profile
    //     $profile->delete();

    //     // Block the content creator from re-login (set a flag or status)
    //     $user->status = 'deleted';  // You may create a "status" column to track if the profile is deleted.
    //     $user->save();

    //     // Redirect to registration page (this will be handled in the frontend)
    //     return response()->json(['message' => 'Profile deleted successfully. Redirecting to registration.']);
    // }



    public function destroy(Request $request, $id)
{
    $user = $request->user();
    $profile = CreatorProfile::find($id);

    if (!$profile || $profile->user_id !== $user->id) {
        return response()->json(['message' => 'Unauthorized'], 403);
    }

    $profile->delete();
    $user->status = 'deleted';
    $user->save();

    return response()->json(['message' => 'Profile deleted successfully.']);
}


}

